//Caption: To design First Order Butterworth Low Pass Filter and covert it into
// HPF Using Digital Filter Transformation
clear all;
clc;
close;
s = poly(0,'s');
Omegac = 0.2*%pi; //Filter cutoff frequency
H = Omegac/(s+Omegac); //First order Butterworth IIR filter
T =1;//Sampling period T = 1 Second
z = poly(0,'z');
Hz_LPF = horner(H,(2/T)*((z-1)/(z+1))); //Bilinear Transformation
alpha = -(cos((Omegac+Omegac)/2))/(cos((Omegac-Omegac)/2));
HZ_HPF=horner(Hz_LPF,-(z+alpha)/(1+alpha*z))//LPF to HPF digital transformation
HW  =frmag(HZ_HPF(2),HZ_HPF(3),512); //Frequency response for 512 points
W = 0:%pi/511:%pi;
a=gca();
a.thickness = 1;
plot(W/%pi,HW,'r')
a.foreground = 1;
a.font_style = 9; 
xgrid(1)
xtitle('Magnitude Response of Single pole HPF Filter Cutoff frequency = 0.2*pi','Normalized Digital Frequency W/pi--->','Magnitude');